/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.util;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractFlags8<T extends Enum<T>, F extends AbstractFlags8<T, F>>
implements Iterable<T> {
    private final byte value;

    public static byte makeMask(Enum<?> value) {
        return (byte)(1 << value.ordinal());
    }

    public static byte makeMask(Enum<?> ... values) {
        return AbstractFlags8.makeMask(Arrays.asList(values));
    }

    public static byte makeMask(Iterable<? extends Enum<?>> values) {
        byte value = 0;
        for (Enum<?> val : values) {
            value = (byte)(value | AbstractFlags8.makeMask(val));
        }
        return value;
    }

    protected AbstractFlags8(byte value) {
        this.value = value;
    }

    protected final byte getValue() {
        return this.value;
    }

    protected abstract Class<T> getType();

    protected abstract F create(byte var1);

    public boolean isEmpty() {
        return this.value == 0;
    }

    public boolean has(T val) {
        return (this.value & AbstractFlags8.makeMask(val)) != 0;
    }

    public boolean hasAny(T ... values) {
        return (this.value & AbstractFlags8.makeMask(values)) != 0;
    }

    public boolean hasAny(F values) {
        return (this.value & ((AbstractFlags8)values).getValue()) != 0;
    }

    public boolean hasAll(T ... values) {
        byte mask = AbstractFlags8.makeMask(values);
        return (this.value & mask) == mask;
    }

    public boolean hasAll(F values) {
        byte mask = ((AbstractFlags8)values).getValue();
        return (this.value & mask) == mask;
    }

    public F and(T val) {
        return this.create((byte)(this.value | AbstractFlags8.makeMask(val)));
    }

    public F and(T ... values) {
        return this.create((byte)(this.value | AbstractFlags8.makeMask(values)));
    }

    public F and(F values) {
        return this.create((byte)(this.value | ((AbstractFlags8)values).getValue()));
    }

    public F except(T val) {
        return this.create((byte)(this.value & ~AbstractFlags8.makeMask(val)));
    }

    public F except(T ... values) {
        return this.create((byte)(this.value & ~AbstractFlags8.makeMask(values)));
    }

    public F except(F values) {
        return this.create((byte)(this.value & ~((AbstractFlags8)values).getValue()));
    }

    public F onlyIn(T val) {
        return this.create((byte)(this.value & AbstractFlags8.makeMask(val)));
    }

    public final F onlyIn(T ... values) {
        return this.create((byte)(this.value & AbstractFlags8.makeMask(values)));
    }

    public F onlyIn(F values) {
        return this.create((byte)(this.value & ((AbstractFlags8)values).getValue()));
    }

    public F where(Predicate<T> predicate) {
        List<T> allowed = this.stream().filter(predicate).toList();
        return this.create((byte)(this.value & AbstractFlags8.makeMask(allowed)));
    }

    public byte serialize() {
        return this.value;
    }

    public Stream<T> stream() {
        return Arrays.stream((Enum[])this.getType().getEnumConstants()).filter(this::has);
    }

    @Override
    public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    public <V> EnumMap<T, V> map(Function<T, V> valueMapper) {
        EnumMap<T, V> map = new EnumMap<T, V>(this.getType());
        for (Enum entry : this) {
            map.put((T)entry, valueMapper.apply(entry));
        }
        return map;
    }

    public String toString() {
        return "[" + this.stream().map(Enum::name).collect(Collectors.joining(", ")) + "]";
    }

    public T random(Random random) {
        if (this.value == 0) {
            throw new IndexOutOfBoundsException();
        }
        int setBits = Integer.bitCount(this.value & 0xFF);
        int index = random.nextInt(setBits);
        return (T)((Enum)this.stream().skip(index).findAny().orElseThrow());
    }
}

